require( "quest/mg_chickenfield/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

round_num = 
{
	8, -- round one
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(0) + SECONDS(30) + SECONDS(5)*level;
end

initial_setup = true;
activity_paused = true;
show_activity_text = false;

function setup_activity()
	local activityNum = game:Get("mg_chickenfield_activity_num");
	local activityRound = game:Get("mg_chickenfield_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
	else
		if not activityMode then
			kill_chickens();
		end
	end
	
	if not activityMode then
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	spawn_chickens();
	
	move_target_chicken_on()
	
	activity_paused = false;
end;

function next_activity(flo)
	local activityNum = game:Get("mg_chickenfield_activity_num");
	local activityRound = game:Get("mg_chickenfield_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if not activityMode and roundComplete then	
		goto_scene(flo, "mg_chickenchorus");	
	else
		if not activityMode then
			scene.NEXT_ACTIVITY_BUTTON:Expire();
		end
		
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				spawn_button(fail_activity_button_spec);
			end
		end
		
		if not activityMode then
			spawn_button(hint_button_spec);
			move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		end
		
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		if not activityMode then
			-- load new puzzle
			setup_activity();
		else
			kill_activity_timer();
			kill_chickens();
			spawn_button(start_button_spec);
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
		end
	end
end;

function activity_passed(flo)
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	local activityNum = game:Get("mg_chickenfield_activity_num");
	local activityRound = game:Get("mg_chickenfield_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;
	activity_paused = true;
	
	game:Set("mg_chickenfield_chicken_found_" .. activityNum, 1);
	
	sfx:PlaySFX("audio/sfx/chicken_match");
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
		if not activityMode then
			scene.FAIL_ACTIVITY_BUTTON:Expire();
		end
	end
	
	if not activityMode then
		scene.HINT_BUTTON:Expire();
	end
	
	scene.BACK_BUTTON:Expire();
	
	move_correct_chicken_to_target();
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
		
		help_panel_say_raw(
			scene:grabstring("finished_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		
		if roundComplete then	
			if activityRound == 1 then
				complete_quest("pass_chickenfield", true, true);
				wait_subscene();
				game:Set("mg_chickenfield_activity_round", 2);
				game:Set("mg_chickenfield_activity_num", 1);
			else -- round == 2
				game:Set("mg_chickenfield_activity_round", 3);
				game:Set("mg_chickenfield_activity_num", 1);
			end
		else
			game:Set("mg_chickenfield_activity_num", activityNum + 1);
		end
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_pattern.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_chickenchaser");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

game_controller_spec = 
{
	name = "GAME_CONTROLLER";
}

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

moving_actor = nil;
COLOR_RED = { a = 1, r = 0.86, g = 0.07, b = 0.07 };
COLOR_GREEN = { a = 1, r = 0.23, g = 0.6, b = 0.23 };
COLOR_BLUE = { a = 1, r = 0.01, g = 0.35, b = 0.85 };
COLOR_YELLOW = { a = 1, r = 0.95, g = 0.71, b = 0.15 };
COLOR_PURPLE = { a = 1, r = 0.5, g = 0.22, b = 0.78 };
COLOR_CYAN = { a = 1, r = 0.47, g = 0.82, b = 0.82 };
COLOR_BROWN = { a = 1, r = 0.67, g = 0.54, b = 0.23 };
COLOR_TAN = { a = 1, r = .81, g = 0.73, b = 0.55 };

target_chicken_pos = { x = 730, y = 135 };
target_chicken_scale = 1.0;
target_chicken_depth = 595;
pickup_chicken_scale = 1.2;
circle_slide_dist = 200;

chicken_speeds = 
{
	-- round 1
	{
		2,	-- activity1 
		2.25,	-- activity2
		2.5,	-- activity3
		2.75,	-- activity4
		3,	-- activity5
		3.25,	-- activity6
		3.5,	-- activity7
		4,	-- activity8
	},
	
	-- activity mode
	{
		2,	-- activity1 
		2.1,	-- activity2
		2.2,	-- activity3
		2.3,	-- activity4
		2.4,	-- activity5
		2.5,	-- activity6
		2.6,	-- activity7
		2.7,	-- activity8
		2.8,	-- activity9
		2.9,	-- activity10
		3,	-- activity11
		3.1,	-- activity12
		3.2,	-- activity13
		3.3,	-- activity14
		3.4,	-- activity15
		3.5,	-- activity16
		3.6,	-- activity17
		3.7,	-- activity18
		3.8,	-- activity19
		3.9,	-- activity20
	},
};
chicken_scene_transition_speed = 10;

chicken_table = 
{
	-- round 1
	{ 
		-- chicken at the top of the table is the target chicken
		{	-- activity 1
			{ number = 1, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 50, y = 150, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 2, x = 600, y = 380, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 400, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 340, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 380, y = 420, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 180, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 280, y = 440, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 320, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 190, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 520, y = 200, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 560, y = 250, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
						       
			{ number = 1, x = 400, y = 260, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 480, y = 300, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 100, y = 320, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 550, y = 340, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 350, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 180, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 1, x = 450, y = 460, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 650, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

		},

--[[
		{	-- activity 1 original
			{ number = 1, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 300, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 400, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 130, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 205, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 135, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 310, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 410, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 140, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 215, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 315, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 415, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 145, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 320, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 150, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 225, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 325, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 155, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 230, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 330, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 430, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 235, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 165, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 240, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 245, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 345, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 175, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 250, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 350, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 450, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 180, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 255, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 355, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 185, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},
]]--	
		{	-- activity 2
			{ number = 1, x = 350, y = 403, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 440, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 445, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 450, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 460, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 465, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 480, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 485, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 400, y = 135, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 155, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 160, body_color = COLOR_TAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 480, y = 180, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 185, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 600, y = 195, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 500, y = 200, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 215, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 450, y = 220, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 230, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 240, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 245, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 400, y = 260, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 300, y = 265, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 280, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 580, y = 300, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 480, y = 305, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 600, y = 320, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 325, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 340, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 345, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 350, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 780, y = 360, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 365, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 370, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},


			{ number = 1, x = 300, y = 375, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 380, body_color = COLOR_TAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 385, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 400, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 410, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 420, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_PURPLE, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
		},

		{	-- activity 3
			{ number = 1, x = 450, y = 360, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 300, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 400, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 130, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 205, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 328, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 420, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color =   COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 210, body_color = COLOR_GREEN, belly_color =   COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 310, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 145, body_color =   COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 215, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 315, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 150, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 440, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 550, y = 320, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 410, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 155, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color =   COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 2, x = 680, y = 225, body_color = COLOR_GREEN, belly_color =   COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 325, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 260, body_color =   COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 230, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 135, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 450, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 460, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 235, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 180, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 425, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color =   COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 270, body_color = COLOR_GREEN, belly_color =   COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 165, body_color =   COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 480, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 2, x = 300, y = 245, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 345, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 250, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 350, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 185, body_color =   COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 465, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color =   COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 255, body_color = COLOR_GREEN, belly_color =   COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 355, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 190, body_color =   COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},

		

		{	-- activity 4
			{ number = 1, x = 650, y = 465, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_BLUE},
			{ number = 1, x = 100, y = 200, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 400, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 300, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 170, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 205,  body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 350, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 250, y = 405, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 150, y = 130, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			
			{ number = 1, x = 280, y = 210, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 310, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 480, y = 410, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 380, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 215, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 315, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 415, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
						       
			{ number = 1, x = 550, y = 320, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 450, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 350, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 225, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 780, y = 325, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 680, y = 425, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
						       
			{ number = 1, x = 100, y = 230, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_PURPLE},
			{ number = 1, x = 400, y = 430, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_PURPLE},
			{ number = 1, x = 300, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_PURPLE},
			{ number = 1, x = 200, y = 180, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_PURPLE},
			
			{ number = 1, x = 50, y = 235,  body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 350, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 250, y = 440, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 150, y = 190, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			
			{ number = 1, x = 280, y = 240, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 580, y = 340, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 480, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 380, y = 125, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 300, y = 245, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 600, y = 345, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 500, y = 450, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 700, y = 145, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 250, y = 250, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 550, y = 350, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 450, y = 460, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 350, y = 155, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 680, y = 275, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 355, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 680, y = 475, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 165, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
		},

		{	-- activity 5
			{ number = 2, x = 320, y = 400, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 100, y = 200, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 300, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 480, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 150, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 205,  body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 305, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 405, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 130, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 310, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 410, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 155, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 215, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 315, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 140, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
						       
			{ number = 1, x = 250, y = 220, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 320, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 420, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 160, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			
			{ number = 1, x = 780, y = 325, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 165, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 100, y = 230, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 450, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 430, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 120, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 235,  body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 135, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 240, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 340, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 170, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 245, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 345, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 470, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 175, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 2, x = 250, y = 260, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 350, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 475, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			{ number = 2, x = 680, y = 275, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 355, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 185, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
		},

--[[		
		{	-- activity 5 original
			{ number = 2, x = 500, y = 215, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 300, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 400, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 175, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 205, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 120, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 310, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 410, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 130, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 245, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 315, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 415, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 140, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 320, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 150, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 225, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 325, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 100, y = 230, body_color = COLOR_RED, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 330, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 430, body_color = COLOR_GREEN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 235, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 180, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 240, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 190, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 2, x = 600, y = 345, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 465, body_color = COLOR_GREEN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 125, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 250, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 370, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 450, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 135, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 255, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 375, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 145, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 110, y = 155, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 320, y = 260, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 260, y = 460, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 690, y = 380, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},

			{ number = 2, x = 100, y = 165, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 390, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 470, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},

		},
]]--
		
		{	-- activity 6
			{ number = 2, x = 300, y = 245, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 100, y = 200, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 400, y = 300, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 300, y = 400, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 125, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 50, y = 205, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 350, y = 305, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 2, x = 250, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 175, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 280, y = 210, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 580, y = 310, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 480, y = 410, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 130, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 215, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 600, y = 315, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 500, y = 415, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 140, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 250, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 550, y = 320, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 450, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 225, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 780, y = 325, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 100, y = 230, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 400, y = 330, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 300, y = 430, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			{ number = 2, x = 200, y = 170, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 50, y = 235, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 350, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 2, x = 250, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 280, y = 240, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 580, y = 360, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 2, x = 480, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 190, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_GREEN},
							    
			{ number = 2, x = 600, y = 345, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 500, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 700, y = 138, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 250, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 370, body_color = COLOR_YELLOW, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
			{ number = 1, x = 450, y = 450, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 135, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 255, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 780, y = 375, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 680, y = 455, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 580, y = 145, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

			{ number = 1, x = 110, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 320, y = 260, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 260, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 690, y = 380, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

			{ number = 2, x = 100, y = 165, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 400, y = 390, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 300, y = 470, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

		},

		
		{	-- activity 7
			{ number = 2, x = 260, y = 395, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 100, y = 200, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 400, y = 300, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 300, y = 400, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 200, y = 110, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 50, y = 205, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 350, y = 305, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 250, y = 405, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 150, y = 120, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 280, y = 210, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 580, y = 310, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 480, y = 410, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 380, y = 130, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 300, y = 215, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 600, y = 315, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 500, y = 415, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 700, y = 140, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
						       
			{ number = 2, x = 250, y = 220, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 550, y = 320, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 450, y = 420, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 350, y = 150, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
							    
			{ number = 2, x = 680, y = 225, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 780, y = 325, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 580, y = 160, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
						       
			{ number = 2, x = 100, y = 230, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 400, y = 330, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 300, y = 430, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			{ number = 2, x = 200, y = 170, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 50, y = 235, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 350, y = 335, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 250, y = 435, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 150, y = 180, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 280, y = 240, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 580, y = 360, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 480, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
			{ number = 2, x = 380, y = 190, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
							    
			{ number = 2, x = 600, y = 345, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 500, y = 465, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 700, y = 125, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
							    
			{ number = 2, x = 250, y = 250, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 370, body_color = COLOR_RED, belly_color = COLOR_BLUE, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			{ number = 2, x = 450, y = 450, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 135, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
							    
			{ number = 2, x = 680, y = 255, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 780, y = 375, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 680, y = 455, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 580, y = 145, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

			{ number = 2, x = 110, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 320, y = 260, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 260, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 690, y = 380, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

			{ number = 2, x = 100, y = 160, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 400, y = 390, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 300, y = 470, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},

		},
		
		{	-- activity 8
			{ number = 2, x = 430, y = 395, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 100, y = 200, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 300, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 400, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 200, y = 110, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			
			{ number = 2, x = 50, y = 205, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 305, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 405, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 150, y = 120, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			
			{ number = 2, x = 280, y = 210, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 310, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 410, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 380, y = 130, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			
			{ number = 2, x = 300, y = 215, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 315, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 415, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 700, y = 140, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
						       
			{ number = 2, x = 250, y = 220, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 320, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 420, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 350, y = 150, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
							    
			{ number = 2, x = 680, y = 225, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 325, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 580, y = 160, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
						       
			{ number = 2, x = 100, y = 230, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 330, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 430, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			{ number = 2, x = 200, y = 170, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			
			{ number = 2, x = 50, y = 235, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 335, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 435, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 150, y = 180, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
			
			{ number = 2, x = 280, y = 240, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 360, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 440, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
			{ number = 2, x = 380, y = 190, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color =  COLOR_TAN},
							    
			{ number = 2, x = 600, y = 345, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 465, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 125, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
							    
			{ number = 2, x = 250, y = 250, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 370, body_color =  COLOR_BROWN, belly_color =  COLOR_YELLOW, wings_color =  COLOR_TAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 450, body_color =  COLOR_BROWN, belly_color =  COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 135, body_color =  COLOR_BROWN, belly_color = COLOR_RED, wings_color =  COLOR_TAN, tail_color =  COLOR_TAN},
							    
			{ number = 2, x = 680, y = 255, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 375, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 455, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 145, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 2, x = 110, y = 155, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 320, y = 260, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 260, y = 460, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 690, y = 380, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 2, x = 100, y = 160, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 390, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 470, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_RED, belly_color =  COLOR_TAN, wings_color =  COLOR_YELLOW, tail_color = COLOR_RED},

		},
--[[
		{	-- activity 8 ORIGINAL
			{ number = 2, x = 430, y = 395, body_color =  COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color =  COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 100, y = 200, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 300, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 400, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 200, y = 110, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 50, y = 205, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 305, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 405, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 150, y = 120, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 280, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 310, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 410, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 380, y = 130, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 300, y = 215, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 315, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 700, y = 140, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
						       
			{ number = 2, x = 250, y = 220, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 320, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 420, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 350, y = 150, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
							    
			{ number = 2, x = 680, y = 225, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 325, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 580, y = 160, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
						       
			{ number = 2, x = 100, y = 230, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 330, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 430, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			{ number = 2, x = 200, y = 170, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 50, y = 235, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 335, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 435, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 150, y = 180, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 280, y = 240, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 360, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 440, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 380, y = 190, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
							    
			{ number = 2, x = 600, y = 345, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 465, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 125, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
							    
			{ number = 2, x = 250, y = 250, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 550, y = 370, body_color = COLOR_PURPLE, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 450, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 135, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
							    
			{ number = 2, x = 680, y = 255, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 375, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 455, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 145, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

			{ number = 2, x = 110, y = 155, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 320, y = 260, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 260, y = 460, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 690, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

			{ number = 2, x = 100, y = 160, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 390, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 470, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

		},
]]--
	},
	
	-- activity mode
	{ 
		-- chicken at the top of the table is the target chicken

		{	-- activity 1
			{ number = 2, x = 530, y = 375, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 140, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 50, y = 150, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 650, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

			{ number = 2, x = 600, y = 380, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 400, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			{ number = 2, x = 380, y = 420, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 280, y = 440, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			
			{ number = 2, x = 280, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 630, y = 180, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 190, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
						       
			{ number = 2, x = 640, y = 210, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 220, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 240, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
						       
			{ number = 2, x = 540, y = 260, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 50, y = 280, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 300, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 420, y = 320, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			{ number = 2, x = 550, y = 340, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 350, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 360, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},


			{ number = 2, x = 450, y = 460, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 780, y = 480, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 180, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

		},
		{	-- activity 2
			{ number = 1, x = 330, y = 445, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 2, x = 600, y = 380, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 390, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 400, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 340, y = 410, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 380, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 180, y = 430, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 280, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 320, y = 450, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 190, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 520, y = 200, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 560, y = 250, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
						       
			{ number = 1, x = 400, y = 260, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 480, y = 300, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 100, y = 320, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 550, y = 340, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 350, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 180, y = 370, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 1, x = 450, y = 460, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 650, y = 470, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

		},

		{	-- activity 3
			{ number = 1, x = 100, y = 130, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 150, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 195, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
		},

		{	-- activity 4
			{ number = 1, x = 300, y = 435, body_color = COLOR_CYAN, belly_color = COLOR_BLUE, wings_color = COLOR_GREEN, tail_color = COLOR_BLUE},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 190, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_RED, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 400, y = 260, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 320, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 350, body_color = COLOR_RED, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},


			{ number = 2, x = 600, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 390, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 380, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 280, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 450, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 450, y = 460, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

		},


		{	-- activity 5
			{ number = 1, x = 350, y = 403, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 440, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 445, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 450, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 460, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 465, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 485, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 400, y = 135, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 300, y = 140, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 160, body_color = COLOR_TAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 480, y = 180, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 185, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 600, y = 195, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 500, y = 200, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 215, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 450, y = 220, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 230, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 245, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 400, y = 260, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 300, y = 265, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 280, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 580, y = 300, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 480, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 600, y = 320, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 325, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 345, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 350, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 365, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 370, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},


			{ number = 1, x = 300, y = 375, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 380, body_color = COLOR_TAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 385, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 400, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 410, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_CYAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 420, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_CYAN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
		},
	
		{	-- activity 6
			{ number = 2, x = 600, y = 380, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_BLUE},
			{ number = 1, x = 300, y = 140, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_GREEN},
			{ number = 2, x = 50, y = 150, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED},

			{ number = 2, x = 250, y = 160, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 280, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 190, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},

			{ number = 2, x = 600, y = 195, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 210, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 780, y = 240, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 400, y = 260, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 580, y = 300, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 600, y = 320, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 325, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},


			{ number = 1, x = 100, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 500, y = 385, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 330, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 600, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

		},

		{	-- activity 7
			{ number = 1, x = 350, y = 253, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 2, x = 400, y = 135, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 145, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 155, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 160, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 2, x = 150, y = 165, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 480, y = 180, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 185, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 600, y = 195, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 205, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 450, y = 220, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 230, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 240, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 245, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 400, y = 260, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 280, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 285, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 290, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 2, x = 580, y = 300, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 380, y = 310, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 320, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 325, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 330, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 345, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 350, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 360, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 370, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},


			{ number = 1, x = 300, y = 375, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 380, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 390, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 405, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 410, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 420, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 440, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 450, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 465, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 470, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 485, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 490, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_GREEN},
		},


		
		{	-- activity 8
			{ number = 1, x = 200, y = 260, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 300, y = 140, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 200, y = 145, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_YELLOW},
			
			{ number = 2, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 250, y = 160, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_YELLOW},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 380, y = 185, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 500, y = 200, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
						       
			{ number = 1, x = 550, y = 215, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_CYAN},
			{ number = 2, x = 350, y = 230, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_BLUE}, 
			{ number = 2, x = 680, y = 245, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 300, y = 265, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_YELLOW},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
			
			{ number = 2, x = 580, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 480, y = 305, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 500, y = 325, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 2, x = 450, y = 345, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 350, y = 350, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_CYAN},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 280, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},


			{ number = 1, x = 300, y = 375, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 500, y = 385, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_YELLOW},
							    
			{ number = 1, x = 550, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 450, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_YELLOW},
			{ number = 1, x = 780, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 1, x = 200, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 700, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_YELLOW},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_CYAN},
			{ number = 1, x = 550, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_YELLOW},
							    
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_YELLOW},
			{ number = 2, x = 180, y = 485, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_CYAN},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_YELLOW},
		},


	
		{	-- activity 9
			{ number = 2, x = 610, y = 425, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_CYAN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 160, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 165, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 180, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 185, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 195, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 250, y = 210, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 230, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 245, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 250, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 265, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 285, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 295, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_CYAN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 345, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 350, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 365, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 405, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 425, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 465, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 485, body_color = COLOR_GREEN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},


		{	-- activity 10
			{ number = 1, x = 730, y = 450, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 150, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 165, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 185, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 195, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 245, body_color = COLOR_RED, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 265, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 345, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_RED, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_PURPLE, belly_color = COLOR_YELLOW, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},
	
		
		{	-- activity 11
			{ number = 1, x = 300, y = 200, body_color = COLOR_RED, belly_color = COLOR_PURPLE, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 150, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 165, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_PURPLE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 185, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 195, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 245, body_color = COLOR_RED, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 265, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 345, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_RED, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_RED, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_CYAN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_CYAN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_PURPLE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_PURPLE, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},
		
	
		{	-- activity 12
			{ number = 1, x = 400, y = 230, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 155, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 165, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 180, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 185, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 195, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 250, y = 210, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 230, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 245, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 250, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 265, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 270, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 280, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 250, y = 285, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 295, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 300, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 345, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 350, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 365, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_YELLOW, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 410, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 350, y = 470, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 680, y = 485, body_color = COLOR_GREEN, belly_color = COLOR_PURPLE, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},

		
		{	-- activity 13
			{ number = 1, x = 100, y = 130, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 135, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 185, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BLUE, belly_color = COLOR_YELLOW, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_PURPLE, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_CYAN, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 245, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 265, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 2, x = 350, y = 280, body_color = COLOR_CYAN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 300, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_CYAN, belly_color = COLOR_BLUE, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 345, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 780, y = 360, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_CYAN, belly_color = COLOR_YELLOW, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_BLUE, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_GREEN, belly_color = COLOR_CYAN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_YELLOW, belly_color = COLOR_GREEN, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_CYAN, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},
		

		
		{	-- activity 14
			{ number = 1, x = 200, y = 403, body_color = COLOR_BROWN, belly_color = COLOR_YELLOW, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 440, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 445, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 450, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 460, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 465, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 480, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 485, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 400, y = 135, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 300, y = 140, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 155, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 160, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 175, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 480, y = 180, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 380, y = 185, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 600, y = 195, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 500, y = 200, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 215, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 450, y = 220, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 230, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 240, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 245, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 580, y = 250, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 400, y = 260, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 300, y = 265, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 280, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 250, y = 285, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 580, y = 300, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 480, y = 305, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 320, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 325, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 340, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 345, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 350, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 360, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 365, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 370, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},


			{ number = 1, x = 300, y = 375, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 600, y = 380, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 500, y = 385, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 550, y = 400, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 450, y = 405, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 780, y = 420, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 2, x = 680, y = 425, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_YELLOW, tail_color = COLOR_GREEN},


		},
		
		
		{	-- activity 15
			{ number = 1, x = 610, y = 323, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 135, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 165, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 185, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 195, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 245, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 265, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 300, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 345, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 375, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},

			{ number = 1, x = 300, y = 435, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_YELLOW, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_GREEN, belly_color = COLOR_RED, wings_color = COLOR_BLUE, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_YELLOW, belly_color = COLOR_RED, wings_color = COLOR_GREEN, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BLUE, belly_color = COLOR_RED, wings_color = COLOR_CYAN, tail_color = COLOR_RED},
		},
		
		{	-- activity 16
			{ number = 1, x = 210, y = 343, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_TAN},

			{ number = 1, x = 300, y = 435, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 440, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 445, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 450, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 455, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 460, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 465, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 470, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 475, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 480, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 485, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 490, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 400, y = 135, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 300, y = 140, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 200, y = 145, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 150, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 155, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 160, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 150, y = 165, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 1, x = 280, y = 170, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 175, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 480, y = 180, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 380, y = 185, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 1, x = 300, y = 190, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 600, y = 195, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 500, y = 200, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 205, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
						       
			{ number = 2, x = 250, y = 210, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 215, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 450, y = 220, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 230, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 235, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 240, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 245, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 250, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
						       
			{ number = 1, x = 100, y = 255, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 400, y = 260, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 300, y = 265, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 200, y = 270, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 1, x = 50, y = 275, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 280, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 250, y = 285, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 150, y = 290, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			
			{ number = 2, x = 280, y = 295, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 580, y = 300, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 480, y = 305, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 380, y = 310, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 300, y = 315, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 320, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 325, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 330, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 335, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 340, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 345, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 350, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 355, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 360, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 365, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 370, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},


			{ number = 1, x = 300, y = 375, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 600, y = 380, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 500, y = 385, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 700, y = 390, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 250, y = 395, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 550, y = 400, body_color = COLOR_TAN, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 450, y = 405, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 350, y = 410, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
							    
			{ number = 1, x = 680, y = 415, body_color = COLOR_RED, belly_color = COLOR_BROWN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 780, y = 420, body_color = COLOR_BROWN, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 2, x = 680, y = 425, body_color = COLOR_RED, belly_color = COLOR_TAN, wings_color = COLOR_RED, tail_color = COLOR_RED},
			{ number = 1, x = 580, y = 430, body_color = COLOR_BROWN, belly_color = COLOR_RED, wings_color = COLOR_RED, tail_color = COLOR_RED},
		},
		
		
	},
}

function noproc(actor)
end;

function move_correct_chicken_to_target()
	local cs = scene.CHICKEN_1_false;
	local ct = scene.CHICKEN_1_true;
	cs.pause = true;
	cs:StartProc(noproc);
	cs:DumpZone();
	coroutine.yield(RESUME.NOW); -- wait a frame
	
	-- stop chicken animation playing and face same direction
	cs:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	cs:PlayAnim("FlapE");
	cs:FaceNow(DIR.E);
	cs:SetScale(target_chicken_scale);
	cs:SetDepthMode(DEPTH.DEPTH_FIXED);		-- depth by y
	cs:SetDepthValue(target_chicken_depth);
	for i,v in pairs(cs.children) do
		v:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		v:PlayAnim("FlapE");
		v:FaceNow(DIR.E);
		v:SetScale(target_chicken_scale);
		v:SetDepthMode(DEPTH.DEPTH_FIXED);		-- depth by y
		v:SetDepthValue(target_chicken_depth-1);
	end
	
	ct:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	ct:PlayAnim("FlapE");
	for i,v in pairs(ct.children) do
		v:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		v:PlayAnim("FlapE");
	end
	
	local pos = cs:GetPosition();
	local moveTime = 60;
	local timer = 0;
	
	while timer < moveTime do
		local newPoint = { x = 0, y = 0 };
		local delta = timer / moveTime;
		
		newPoint.x = pos.x + ((target_chicken_pos.x - pos.x) * delta);
		newPoint.y = pos.y + ((target_chicken_pos.y - pos.y) * delta);
		cs:JumpToPoint(newPoint);
		
		for i,v in pairs(cs.children) do
			v:JumpToPoint(newPoint);
		end
		
		timer = timer + 1;
		delay(1);
	end
	
	cs:SetAlpha(0);
	for i,v in pairs(cs.children) do
		v:SetAlpha(0);
	end
	
	delay(30);
	
	move_target_chicken_off();
end

-- move the chicken and circle off screen
function move_target_chicken_off()
	local ct = scene.CHICKEN_1_true;
	
	local dist = 0;
	local speed = 5;
	
	while dist < circle_slide_dist do
		local pos = ct:GetPosition();
		pos.y = pos.y - speed;
		
		ct:JumpToPoint(pos);
		for i,v in pairs(ct.children) do
			v:JumpToPoint(pos);
		end
		
		pos = scene.TARGET_CIRCLE:GetPosition();
		pos.y = pos.y - speed;
		
		scene.TARGET_CIRCLE:JumpToPoint(pos);
		
		dist = dist + speed;
		delay(1);
	end;
end;

-- move the chicken and circle on screen
function move_target_chicken_on()
	local ct = scene.CHICKEN_1_true;
	local dist = 0;
	local speed = 5;
	
	sfx:PlaySFX("audio/sfx/chicken_appear");
	
	while dist < circle_slide_dist do
		local pos = ct:GetPosition();
		pos.y = pos.y + speed;
		
		ct:JumpToPoint(pos);
		for i,v in pairs(ct.children) do
			v:JumpToPoint(pos);
		end
		
		pos = scene.TARGET_CIRCLE:GetPosition();
		pos.y = pos.y + speed;
		
		scene.TARGET_CIRCLE:JumpToPoint(pos);
		
		dist = dist + speed;
		delay(1);
	end;
	
	ct:PlayAnim("DoStandE");
	for i,v in pairs(ct.children) do
		v:PlayAnim("DoStandE");
	end
end

function kill_chicken(chicken)
	for i,v in pairs(chicken.children) do
		v:Expire();
	end
	chicken.children = nil;
	chicken:Expire();
end

function kill_chickens()
	 -- pause the target chicken
	scene.CHICKEN_1_true.pause = true;
	chickens_expired = 2;
	
	-- tell the rest of the chickens to hold on a sec
	local chicken_num = 1;
	while true do
		local chicken_name = "CHICKEN_" .. chicken_num .. "_false";
		local chicken_actor = scene[chicken_name];
		if chicken_actor then
			chicken_actor.pause = true
		else
			break;
		end
		
		chicken_num = chicken_num + 1;
	end
	
	delay(5);
	
	-- tell the rest of the chickens to leave
	local chicken_num = 2;
	while true do
		local chicken_name = "CHICKEN_" .. chicken_num .. "_false";
		local chicken_actor = scene[chicken_name];
		if chicken_actor then
			chicken_actor.pause = false;
			chicken_actor.leave_scene = true;
			chicken_actor:DumpZone();
		else
			break;
		end
		
		chicken_num = chicken_num + 1;
	end

	 -- kill target chicken
	kill_chicken(scene.CHICKEN_1_true);
	kill_chicken(scene.CHICKEN_1_false);
	
	-- wait for the rest of the chickens to die
	while chickens_expired ~= chicken_num do
		delay(1);
	end
end

function spawn_chickens()
	local round = game:Get("mg_chickenfield_activity_round");
	local activity_num = game:Get("mg_chickenfield_activity_num");
	local activity_mode = game:Get("activity_mode") == 1;
	
	if activity_mode then
		activity_num = game:Get("activity_mode_level");
		round = table.getn(round_num);
	end
	
	local num_chickens = table.getn(chicken_table[round][activity_num]);
	local count = math.random(1, num_chickens);
	
	--debug_out(count .. " " .. num_chickens);
	
	for i=1,num_chickens do
		if count == 1 then
			spawn_chicken(count, chicken_table[round][activity_num][count], true);
		end
		
		spawn_chicken(count, chicken_table[round][activity_num][count], false);
		
		delay(6);
		
		count = count + 1;
		
		if count > num_chickens then
			count = 1;
		end
	end
end

function spawn_chicken(number, data, target)
	local chicken_skeleton = scene:Spawn(get_chicken_spec(number, data, target));
	local chicken_wings = scene:Spawn(get_chicken_wings_spec(number, data, target));
	local chicken_body = scene:Spawn(get_chicken_body_spec(number, data, target));
	local chicken_belly = scene:Spawn(get_chicken_belly_spec(number, data, target));
	local chicken_tail = scene:Spawn(get_chicken_tail_spec(number, data, target));
	
	chicken_skeleton.children = { };
	table.insert(chicken_skeleton.children, chicken_wings);
	table.insert(chicken_skeleton.children, chicken_body);
	table.insert(chicken_skeleton.children, chicken_belly);
	table.insert(chicken_skeleton.children, chicken_tail);
	
	chicken_skeleton:FaceNow(DIR.E);
	
	for i,v in pairs(chicken_skeleton.children) do
		v:FaceNow(DIR.E)
	end
end

function move_chicken(position, actor, speed_override)
	local currentPos = actor:GetPosition();
	local faceDir = DIR.W;
	local activity_num = game:Get("mg_chickenfield_activity_num");
	local round = game:Get("mg_chickenfield_activity_round");
	local speed = speed_override;
	
	if speed == nil or speed_override == 0 then
		speed = chicken_speeds[round][activity_num];
	end
	
	if position.x == currentPos.x then
		return;
	end;
	
	if position.x > currentPos.x then
		faceDir = DIR.E
	end
	
	-- set facing position
	actor:FaceNow(faceDir);
	actor.direction = faceDir;
	
	for i,v in pairs(actor.children) do
		v:FaceNow(faceDir);
	end
	
	-- play walk anim
	actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	actor:PlayAnim("DoWalkE");
		
	for i,v in pairs(actor.children) do
		v:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		v:PlayAnim("DoWalkE");
	end
	
	if faceDir == DIR.W then
		actor:SetScaleX(-1);
		
		for i,v in pairs(actor.children) do
			v:SetScaleX(-1);
		end
	end
	
	local done = false;
	
	while not done do
		if faceDir == DIR.E then
			if position.x > currentPos.x then
				currentPos.x = currentPos.x + speed;
				
				if position.x < currentPos.x then
					currentPos.x = position.x;
					done = true;
				end
			else
				done = true;
			end
		else
			if position.x < currentPos.x then
				currentPos.x = currentPos.x - speed;
				
				if position.x > currentPos.x then
					currentPos.x = position.x;
					done = true;
				end
			else
				done = true;
			end
		end
	
		actor:JumpToPoint(currentPos);
		
		for i,v in pairs(actor.children) do
			v:JumpToPoint(currentPos);
		end
		
		if actor.pause then
			break;
		else
			delay(1);
		end
	end
	
	actor:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	actor:SetScaleX(1);
	actor:FaceNow(DIR.E);
	actor:PlayAnim("DoStandE");
	
	for i,v in pairs(actor.children) do
		v:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		v:SetScaleX(1);
		v:FaceNow(DIR.E);
		v:PlayAnim("DoStandE");
	end
	
	if faceDir == DIR.W then
		actor:FaceNow(DIR.W);
		
		for i,v in pairs(actor.children) do
			v:FaceNow(DIR.W);
		end
	end
	
end

function get_chicken_spec(num, chicken_data, target)
	return 
	{
		name = "CHICKEN_" .. num .. "_" .. tostring(target);
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_skeleton" };
		halo = "chicken" .. chicken_data.number;
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
			
			if target == true then
				actor:SetDepthMode(DEPTH.DEPTH_FIXED);		-- depth by y
				actor:SetDepthValue(target_chicken_depth);
			else
				actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
				actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
			end
			prepare_actor_text(actor);
			actor:SetPointAtCursor("cursor_open_hand");
			actor.direction = DIR.E;
			--actor:SayRaw("chicken " .. num .. " has arrived");
			
			if target == true then
				actor:JumpToPoint { x = target_chicken_pos.x, y = target_chicken_pos.y - circle_slide_dist };
			else
				local position = { x = chicken_data.x, y = chicken_data.y };
				
				if position.x < 400 then
					position.x = -100;
				else
					position.x = 900;
				end
				
				actor:JumpToPoint(position);
			end
			
			while actor.children == nil do
				coroutine.yield(RESUME.NOW);
			end
			
			local original_pos = actor:GetPosition();
			
			actor.pause = false;
			actor.moving = false;
			actor.chicken_data = chicken_data;
			actor.target = target;
			actor.num = num;
			actor.initial_spawn = true;
			actor.leave_scene = false;
			
			if target == false then
				actor:StartProc(walk_about);
			end
			
		end;
		
		point_at_fn = function(actor, enter)
			if enter then
				actor.pause = true;
			else
				actor.pause = false;
			end
		end;
		
		on_click = function(flo, actor)
			if activity_paused == false then
				if actor.target == false then
					if actor.moving == false then
						if actor.num == 1 then
							flo:StartProc(activity_passed);
						elseif moving_actor == nil then -- pick up the item
							local clickedAt = scene:GetClickedAtScreen();
							local actorPos = actor:GetPosition();
							actor.moving = true;
							actor.pause = true;
							actor.movingx = actorPos.x - clickedAt.x;
							actor.movingy = actorPos.y - clickedAt.y;
							
							--actor:SetDepthMode(DEPTH.DEPTH_FIXED);
							--actor:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
							--actor:SetDepthValue(600);
							--for i,v in pairs(actor.children) do
							--	v:SetDepthMode(DEPTH.DEPTH_FIXED);
							--	v:SetDepthValue(600);
							--	v:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
							--end
							
							actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
							actor:PlayAnim("FlapE");
							
							actor:SetDepthMode(DEPTH.DEPTH_FIXED);
							actor:SetDepthValue(600);
							actor:SetScale(pickup_chicken_scale);
							actor:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
							
							for i,v in pairs(actor.children) do
								v:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
								v:PlayAnim("FlapE");
								v:SetDepthMode(DEPTH.DEPTH_FIXED);
								v:SetDepthValue(599);
								v:SetScale(pickup_chicken_scale);
								v:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
							end
							
							if actor.direction == DIR.W then
								actor:SetScaleX(-pickup_chicken_scale);
								
								for i,v in pairs(actor.children) do
									v:SetScaleX(-pickup_chicken_scale);
								end
							end
							
							scene.BACKGROUND_CURSOR:LoadZone("background");
							actor:StartProc(move_item);
							--actor:SayRaw("moving");
							moving_actor = actor;
							actor:DumpZone();
							scene.GAME_CONTROLLER:StartProc(moving_item);
							sfx:PlaySFX("audio/sfx/chicken_cluck" .. math.random(1,8) .. ".ogg");
						end
						return RESPONSE.IGNORE;
					else
						stop_moving(actor);
						moving_actor = nil;
					end
				end
			end
		end
		--[[
		on_release = function(flo, chicken)
			-- swap the grid indexes of the actors
			if moving_actor ~= nil then
				local temp = moving_actor.grid_index;
				moving_actor.grid_index = actor.grid_index;
				actor.grid_index = temp;
				
				-- swap the actors in the grid
				activity_data.grid[actor.grid_index].actor = actor;
				activity_data.grid[moving_actor.grid_index].actor = moving_actor;
				
				-- move this actor (moving_actor handled elsewhere)
				actor:JumpToPoint(activity_data.grid[actor.grid_index]);
			end
		end
		--]]
	}
end

function move_item(actor)
	while actor.moving do
		local cursorPos = scene:GetCursorPos();
		local actorPos = actor:GetPosition();
		actorPos.x = cursorPos.x + actor.movingx;
		actor:JumpToPoint(actorPos);
		
		for i,v in pairs(actor.children) do
			v:JumpToPoint(actorPos);
		end
		coroutine.yield(RESUME.NOW);
	end;
end;

function walk_about(actor)
	local original_pos = { x = actor.chicken_data.x, y = actor.chicken_data.y };
	
	while true do
		local chicken_speed_override = 0;
		local leaving = actor.leave_scene;
		
		if actor.initial_spawn == false and leaving == false then
			delay(math.random(100, 300));
		elseif leaving == true then
			chicken_speed_override = chicken_scene_transition_speed;
		else
			actor.initial_spawn = false;
			chicken_speed_override = chicken_scene_transition_speed;
		end
		
		local position = original_pos;
		
		if leaving == true then
			local actor_pos = actor:GetPosition();
			if actor_pos.x < 400 then
				position.x = -100;
			else
				position.x = 900;
			end
		else
			position.x = position.x + math.random(-100, 100);
			position.x = math.max(position.x, 50);
			position.x = math.min(position.x, 750);
		end
		
		if math.random(1,5) == 3 then
			
			sfx:PlaySFX("audio/sfx/chicken_cluck" .. math.random(1,8) .. ".ogg");
		end
		
		if actor.pause == false then
			move_chicken(position, actor, chicken_speed_override);
		end
		
		if leaving == true then
			kill_chicken(actor);
			chickens_expired = chickens_expired + 1;
			return;
		else
			while actor.pause do
				delay(1);
			end
		end
	end
end

function stop_moving(actor)
	--actor:JumpToPoint { x = actor.chicken_data.x, y = actor.chicken_data.y };
	--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
	--
	
	--for i,v in pairs(actor.children) do
	--	v:JumpToPoint { x = actor.chicken_data.x, y = actor.chicken_data.y };
	--	v:SetDepthMode(DEPTH.DEPTH_BY_Y);
	--	v:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
	--end
	
	scene.BACKGROUND_CURSOR:DumpZone();
	
	actor:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	actor:SetScale(1);
	actor:FaceNow(DIR.E);
	actor:PlayAnim("DoStandE");
	
	actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
	actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
	
	for i,v in pairs(actor.children) do
		v:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		v:SetScale(1);
		v:FaceNow(DIR.E);
		v:PlayAnim("DoStandE");
		v:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		v:SetDepthValue(v:GetPosition().y-1);
		--v:SetDepthMode(DEPTH.DEPTH_BY_Y);
	end
	
	if actor.direction == DIR.W then
		actor:FaceNow(DIR.W);
		
		for i,v in pairs(actor.children) do
			v:FaceNow(DIR.W);
		end
	end
	
	sfx:PlaySFX("audio/sfx/chick_" .. math.random(1,8) .. ".ogg");
	
	actor.moving = false;
	actor.pause = false;
	--actor:SayRaw("not moving");
	actor:LoadZone("chicken" .. actor.chicken_data.number);
	
	actor:StartProc(walk_about);
end

-- running as GAME_CONTROLLER proc whilst actor is moving
function moving_item(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.NOW);
	
	-- if we didn't click on another clothing item, put us back
	if moving_actor ~= nil then
		stop_moving(moving_actor);
		moving_actor = nil;	
	end;
	
	-- check if we've solved the puzzle
	--if check_solved() then
	--	scene.FLO:StartProc(activity_passed);
	--end
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function chicken_part_default_command(actor, chicken_data, target)
	if target == true then
		actor:SetDepthMode(DEPTH.DEPTH_FIXED);		-- depth by y
		actor:SetDepthValue(target_chicken_depth-1);
	else
		actor:SetDepthMode(DEPTH.DEPTH_FIXED);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
	end

	actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
	prepare_actor_text(actor);
	
	if target == true then
		actor:JumpToPoint { x = target_chicken_pos.x, y = target_chicken_pos.y - circle_slide_dist };
	else
		local position = { x = chicken_data.x, y = chicken_data.y };
		actor:JumpToPoint(position);
		actor:SetDepthValue(chicken_data.y-1);
	end
end

function get_chicken_body_spec(num, chicken_data, target)
	return
	{
		name = "CHICKEN_BODY_" .. num .. "_" .. tostring(target);
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_body" };
		
		command = function(actor)
			chicken_part_default_command(actor, chicken_data, target);
			actor:SetTint(chicken_data.body_color);
		end;
	}
end

function get_chicken_belly_spec(num, chicken_data, target)
	return
	{
		name = "CHICKEN_BELLY_" .. num .. "_" .. tostring(target);
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_belly" };
		
		command = function(actor)
			chicken_part_default_command(actor, chicken_data, target);
			actor:SetTint(chicken_data.belly_color);
		end;
	}
end

function get_chicken_wings_spec(num, chicken_data, target)
	return
	{
		name = "CHICKEN_WINGS_" .. num .. "_" .. tostring(target);
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_wings" };
		
		command = function(actor)
			chicken_part_default_command(actor, chicken_data, target);
			actor:SetTint(chicken_data.wings_color);
		end;
	}
end

function get_chicken_tail_spec(num, chicken_data, target)
	return
	{
		name = "CHICKEN_TAIL_" .. num .. "_" .. tostring(target);
		gfx = { anim = "anim/chicken/chicken" .. chicken_data.number .. "_tail" };
		
		command = function(actor)
			chicken_part_default_command(actor, chicken_data, target);
			actor:SetTint(chicken_data.tail_color);
		end;
	}
end

target_circle_spec = 
{
	name = "TARGET_CIRCLE";
	gfx = { image = "targetcircle" };
	
	command = function(actor)
		actor:SetDepthValue(580);
		actor:JumpToPoint { x = 0, y = -circle_slide_dist };
	end
}

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	goto_scene(flo, "mg_chickenchorus");
end

background_cursor_spec = 
{
	name = "BACKGROUND_CURSOR";
	--halo = "background";
	
	command = function(actor)
		actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		actor:SetPointAtCursor("cursor_closed_hand");
	end;
}

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		help_panel_say_raw(scene:grabstring("hint_" .. game:Get("mg_chickenfield_activity_num")));
		scene.HELP_PANEL:StartProc(resume_help_on_click);
	end;
}

function resume_help_on_click(help_panel)
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	help_panel_say_raw(scene:grabstring("help_1_" .. tostring(game:Get("mg_chickenfield_activity_num"))));
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_farm.ogg", true);
		scene:SetRoomScale(0, 550, 1.0, 1.0);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		
		fade_scene_up(true);
		lower_hud();
		
		if activityMode then
			spawn_button(start_button_spec);
		else
			spawn_button(hint_button_spec);
		end
		
		spawn_help_panel(true);
		
		if IsCheatMode() then
			-- testing data
			if not activityMode then
				spawn_button(pass_activity_button_spec);
				spawn_button(fail_activity_button_spec);
			end
		end
		
		-- set up for initial play
		if game:Get("mg_chickenfield_activity_num") < 1 then
			game:Set("mg_chickenfield_activity_num", 1);
		end
		
		if game:Get("mg_chickenfield_activity_round") < 1 then
			game:Set("mg_chickenfield_activity_round", 1);
		end
		
		-- unlock chicken field in activity mode
		if game:Get("chicken_field_unlocked") < 1 then
			game:Set("chicken_field_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
	end;
};

scene_spec =
{
	--atlas = 
	--{
	--	"pieces" -- load pieces
	--};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "targetcircle", 580 },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		game_controller_spec,
		flo_spec, -- the main actor
		target_circle_spec,
		background_cursor_spec,
		scene_setup,
	};
};
